import matplotlib.pyplot as plt
import numpy as np

C_B=0.2  #concentration (en mol/L) de la solution titrante (soude)
V_A=5   #volume initial (en mL) de la solution titrée (acide lactique)
V_E=17   #volume (en mL) mesuré à l'équivalence

C_A=C_B*V_E/V_A
n_A=C_B*V_E*1e-3

V_B1=np.linspace(0,V_E,V_E*10+1)
n_a1=(C_A*V_A-C_B*V_B1)*1e-3
n_b1=C_B*V_B1*1e-3
n_B1=0*V_B1

V_B2=np.linspace(V_E,V_E*1.5,V_E*10+1)
n_a2=0*V_B2
n_b2=(0*V_B2+C_B*V_E)*1e-3
n_B2=C_B*(V_B2-V_E)*1e-3

plt.plot(V_B1,n_a1,color="blue",label=" AH")
plt.plot(V_B1,n_b1,color="green",label="A-")
plt.plot(V_B1,n_B1,color="red",label="HO-")

plt.plot(V_B2,n_a2,color="blue")
plt.plot(V_B2,n_b2,color="green")
plt.plot(V_B2,n_B2,color="red")

plt.title("Evolution des quantités de matière des espèces en fonction du volume de solution titrante versée \nTitrage de l' acide lactique par la soude")
plt.legend(loc="upper right")
plt.xlabel("Volume de la solution titrante (en mL)")
plt.ylabel("Quantités de matière des espèces en solution (en mol)")
plt.grid()

plt.show()
