# La bibliothèque 'numpy' permet ici de générer des listes (array) qui se
#   comportent comme des vecteurs.
# La bibliothèque 'matplotlib.pyplot' contient toutes les fonctions permettant
#   le tracé de graphiques.
# La bibliothèque 'scipy' contient des outils mathématiques comme 'lineregress'
#   qui calcule les paramètres d’une régression linéaire effectuée sur une
#   série de points.

import numpy as np
import matplotlib.pyplot as plt 
from scipy import stats

#On note les différentes valeurs de l'intensité du courant (en milliampères)
x = np.array([0.0, 0.9, 2.1, 3.1, 3.9, 5.0, 6.0, 7.1, 8.0, 9.2, 9.9, 11.0,11.9])
x=x/1000 # on converti les milliampères en ampères

#On note les différentes valeurs de la tension
y = np.array([0, 1, 2, 3.2, 4, 4.9, 5.8, 7, 8.1, 9.1, 10, 11.2, 12])

#On construit le tracé des points expérimentaux sur le graphique
plt.plot(x,y,'ob') 

#On calcule la régression linéaire
pente, intercept, r_value, p_value, std_err = stats.linregress(x,y)

# On construit la droite de la régression linéaire sur le graphique
x1=np.linspace(np.min(x),np.max(x),500)
y1=pente*x1+intercept
plt.plot(x1,y1,'-r')

# On ajoute sur le graphique l'équation de la droite moyenne
plt.text(0.004,2,"U =%.2f"%pente+"xI%.4f"%intercept)# On met en forme et on affiche les résultats en console
print("Coefficient directeur de la droite : ",pente, chr(937))
print("Ordonnée à l'origine : ",intercept,"V")

# On ajoute un titre pour chaque axe et pour le graphique 
plt.xlabel("intensité I (A)")
plt.ylabel("tension U (V)")
plt.title("Caractéristique intensité-tension")

plt.show()



