#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <Wire.h>
#include <BH1750.h>

const char * ssid = "BOX";
const char * password = "mot de passe";
ESP8266WebServer server(80);
BH1750 capteurLum;
volatile int mesure;

void setup() {
  Serial.begin(115200);
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print("."); }
  Serial.println("IP address: " + WiFi.localIP());

  server.on("/", []() { server.send(200, "text/html", "<html><head>"
    "<meta http-equiv=\"refresh\" content=\"1\" /></head>"
    "<body>Mesure : " + String(mesure) + "</body></html>"); });
  server.begin();
  Wire.begin(0, 2);
  capteurLum.begin(); }

void loop() {
  mesure = capteurLum.readLightLevel();
  Serial.println("Valeur de la luminosité : ");
  Serial.println(mesure);
  delay(500);
  server.handleClient(); }
