import matplotlib.pyplot as plt
import math as ma
#declaration des différents tableaux
X,t,Y,VX,VY,AX,AY=[],[],[],[],[],[],[]
# période de révolution de l'astre en sende
T_revolution = 3.16e7
#Rayon de l'orbite circulaire en mètre
R=1.5e11
# période de révolution divisées par 30
for i1 in range(35):
	t.append(i1*T_revolution/30)	
t.append(T_revolution)
# Calcul des positions
for i in range (35) : 
	X.append(R*ma.cos(2*ma.pi*t[i]/T_revolution))
	Y.append(R*ma.sin(2*ma.pi*t[i]/T_revolution))	
# calcul des vecteurs vitesses 
for i in range (1,34) : 
	VX.append((X[i+1]-X[i-1])/(2*T_revolution/30))
	VY.append((Y[i+1]-Y[i-1])/(2*T_revolution/30))
# calcul des vecteurs accélération
for i in range (1,32) : 	
	AX.append((VX[i+1]-VX[i-1])/(2*T_revolution/30))
	AY.append((VY[i+1]-VY[i-1])/(2*T_revolution/30))	
# affichage des positions
plt.figure('Mouvement circulaire')
plt.axis('equal')
plt.text(0,0 ,"Soleil", fontsize=15,color='g')
plt.plot(X,Y,"bo")
plt.plot(0,0,"go")
#affichage des vecteurs accélérations
# La longueur des flèches, la tête des flèches doiventt être adapté aux dimensions du problème souhaité
for i in range (31) : 
	plt.arrow(X[i+2],Y[i+2],1e13*AX[i],1e13*AY[i],head_width=0.5e10,head_length =0.5e10,length_includes_head=True)
plt.show()