import matplotlib.pyplot as plt

#####################################################################

####   Coordonnées des points du solide en fonction du temps    #####

fic = open("chronophotographie.csv",'r')                                #
donnee=fic.readlines()                                                  #

t=[] ; x=[] ; y=[]                                                      #

for point in donnee :                                                   #

    point=point.replace('\n','').replace('\r','') #Suppr saut de ligne  #

    point=point.split(';') # Transforme une ligne en une liste          #

    try: #Pour éviter les problèmes liés à des lignes vides

        if point[0][0].isnumeric():  #Pour passer l'en-tête du fichier  #

            t.append(float(point[0].replace(',','.')))

            x.append(float(point[1].replace(',','.')))                  #

            y.append(float(point[2].replace(',','.')))                  #

    except: #Si une erreur est générée, on passe à la ligne suivante    #

        pass                                                            #

#########################################################################

########   Calcul des coordonnées vx et vy du vecteur vitesse    ########

vx=[0] ; vy=[0] ; v=[]                                                  #

for i in range(1,len(x)-1):                                             #

    vx.append((x[i+1]-x[i-1])/(t[i+1]-t[i-1]))                          #

    vy.append((y[i+1]-y[i-1])/(t[i+1]-t[i-1]))                          #

    v.append((vx[-1]**2+vy[-1]**2)**0.5)                                #

#########################################################################

#######  Calcul des coordonnées ax et ay du vecteur accélération  #######

ax=[0] ; ay=[0]  ; a=[]                                                 #

for i in range(2,len(vx)-1):                                            #

    ax.append((vx[i+1]-vx[i-1])/(t[i+1]-t[i-1]))                        #

    ay.append((vy[i+1]-vy[i-1])/(t[i+1]-t[i-1]))                        #

    a.append((ax[-1]**2+ay[-1]**2)**0.5)                                #

#########################################################################

###############    Tracé des champs de vecteurs:     ####################

"""
echel_v=50                                                 #

vec_v=plt.quiver(x[:-1],y[:-1],vx,vy,color="green",
                 angles='xy', scale_units='xy', scale=echel_v, width=0.005)          #

plt.quiverkey(vec_v,X=0.7, Y=1.05,U=1, label='Vitesse')                 #

"""
echel_a=100                                                #

vec_a=plt.quiver(x[1:-2],y[1:-2], ax,ay, color="blue",
                 angles='xy', scale_units='xy', scale=echel_a, width=0.002)          #

plt.quiverkey(vec_a,X=0.2, Y=1.05,U=1e-2,label='Accélération')          #

                                                                       #

plt.plot(x,y,"ro") ; plt.axis('equal')                                  #

plt.show()                                                              #

#################    F I N  D U  P R O G R A M M E    ###################