# -*- coding: utf-8 -*-
"""
Created on Fri Jul  5 09:02:06 2019

@author: itala
"""

import matplotlib.pyplot as plt


# Valeurs expérimentales de Sigma et t
t = [...] #A compléter
Sigma = [...] #A compléter

C0 = ... #A compléter
Sigma0 = ... #A compléter
Sigmaf = ... #A compléter

#Calcul de [HO-]
CHO = []
for i in range (0,len(Sigma)) : 
    CHO.append(C0*(Sigma[i]-Sigmaf)/(Sigma0-Sigmaf))

#Représentation de [HO-] en fonction du temps. Ce graphe n'est pas nécessaire
#mais permet de visualiser si les points expérimentaux sont cohérents. 
plt.plot(t,CHO,"b+")
plt.xlabel("t (s)", fontsize = 12)
plt.ylabel("[HO-] (mol.L-1)", fontsize = 12)
plt.title("[HO-] en fonction du temps", fontsize = 14)
plt.show()

#Calcul de la vitesse de disparition de HO-
VHO = []
for i in range (1, len(CHO)-1): 
    VHO.append(-(CHO[i+1]-CHO[i-1])/(t[i+1]-t[i-1])) 


#Modélisation des points expérimentaux par une droite
import numpy as np
model = np.polyfit(CHO[1:-1],VHO,1)

a = model[0]
VHOmodel = []
for i in range (0, len(CHO)) : 
    VHOmodel.append(a*CHO[i])


#Tracé du graphe V(HO-) en fonction de [HO-] et de la droite de modélisation 
plt.plot(CHO[1:-1],VHO,"r+",label = "Points expérimentaux")
plt.plot(CHO, VHOmodel, "g--", label = "Modélisation")
plt.xlabel("[HO-] (mol.L-1)", fontsize = 12)
plt.ylabel("V(HO-) (mol.L-1.s-1)", fontsize = 12)
plt.title("V(HO-) en fonction [HO-]", fontsize = 14)
plt.legend()

plt.show()





