# -*- coding: utf-8 -*-
"""
Created on Fri Jul  5 09:02:06 2019

@author: itala
"""

import matplotlib.pyplot as plt

# Valeurs expérimentales de l'absorbance A et du temps t
t = [...] # A compléter
A = [...] # A compléter

# Calcul de [I2] (notée CI2) à partir des valeurs de A
CI2 = []
for i in range (0,len(A)) : 
    CI2.append(...) # A compléter

# Tracé du graphe [I2](t)    
plt.plot(t,CI2,"g+")
plt.xlabel("temps (s)", fontsize = 12)
plt.ylabel("[I2] (mol.L-1)", fontsize = 12)
plt.title("[I2] en fonction du temps", fontsize = 14)
plt.show()

# Valeur de la concentration initiale en S2O82- (notée C0S)
C0S = ...  # A compléter 

# Calcul de la concentration en S2O82- (notée CS) au cours de la transformation
CS = []
for i in range (0,len(CI2)) : 
    CS.append(...) # A compléter

# Tracé du graphe [S2O82-](t)
plt.plot(t,CS,"r+")
plt.xlabel("temps (s)", fontsize = 12)
plt.ylabel("[S2O82-] (mol.L-1)", fontsize = 12)
plt.title("[S2O82-] en fonction du temps", fontsize = 14)
plt.show()

# Tracé du graphe VI2(t)
VI2 = []
for i in range(1, len(CI2)-1) :
    VI2.append((CI2[i+1]-CI2[i-1])/(t[i+1]-t[i-1]))

plt.plot(t[1:-1],VI2,"ro")
plt.xlabel("temps (s)", fontsize = 12)
plt.ylabel("vitesse volumique d'apparition du diiode (mol.L-1.s-1)", fontsize = 12)
plt.title("Vitesse volumique d'apparition du diiode en fonction du temps", fontsize = 14)
plt.show()

# Tracé du graphe VS2O82-(t)
VS = []
for i in range(1, len(CS)-1) :
    VS.append(-(CS[i+1]-CS[i-1])/(t[i+1]-t[i-1]))

plt.plot(t[1:-1],VS,"ro")
plt.xlabel("temps (s)", fontsize = 12)
plt.ylabel("vitesse volumique de disparition du S2O82- (mol.L-1.s-1)", fontsize = 12)
plt.title("Vitesse volumique de disparition du S2O82- en fonction du temps", fontsize = 14)
plt.show()

#Tracé de la Vitesse volumique de disparition de S2O82- (notée VS) en fontion de [S2O82-] (notée CS)
plt.plot(CS[1:-1],VS,"ro")
plt.xlabel("[S2O82-] (mol.L-1)", fontsize = 12)
plt.ylabel("vitesse volumique d'apparition (mol.L-1.s-1)", fontsize = 12)
plt.title("Vitesse volumique d'apparition en fonction de la concentration en S2O82-", fontsize = 14)
plt.show()


# Modélisation de la courbe VS([S2O82-]) par une fonction linéaire

import numpy as np
model = np.polyfit(CS[1:-1],VS,1)

a = model[0]
VSmodel = []
for i in range (0, len(CS)) : 
    VSmodel.append(a*CS[i])

plt.plot(CS[1:-1],VS,"ro", label = "Points expérimentaux")
plt.plot(CS, VSmodel, "g--", label = "Modélisation")
plt.xlabel("[S2O82-] (mol.L-1)", fontsize = 12)
plt.ylabel("vitesse volumique de disparition du S2O82- (mol.L-1.s-1)", fontsize = 12)
plt.title("Vitesse volumique de disparition du S2O82- en fonction de la concentration en S2O82-", fontsize = 14)
plt.legend()
plt.show()


