import matplotlib.pyplot as plt
import scipy.stats as stat

# listes des demi-grands axes a en U.A et périodes des planètes en années

LIST_a = [0.39,0.72,1.0,1.5,5.2,9.5,19.2,30.0] #liste des demi-grands axes
LIST_T = [0.24,0.615,1,1.88,11.9,29.4,84,165.0] # liste périodes de révolution
LIST_P = ['Mercure','Venus','Terre','Mars','Jupiter','Saturne','Uranus','Neptune'] # nom des planètes

# création des listes a au cube et T au carré
for i in range(0, len(LIST_a)):
   LIST_a[i] = (LIST_a[i]*150e9)**3 # a est converti en mètre puis élevée au cube
   LIST_T[i] = (LIST_T[i]*365*24*3600)**2 # T estconverti en seconde puis élevé au carré

# régression linéaire
regression = stat.linregress(LIST_a,LIST_T) # regression est une liste des trois données : pente, ordonnée à l'origine et coefficient directeur
pente =regression[0] # récupération dans la variable pente du coefficient directeur
print('pente --> '+str(pente)) # Affichage du coefficient directeur
ordorigine =regression[1] #  récupération dans la variable ordorigine de l'ordonnée à l'origine
print('ordonnée à l origine --> '+str(ordorigine)) # Affichage de l'ordonnée à l'origine
coeffcorel = regression[2] #récupération dans la variable coeffcorel du coefficient de correlation r
print('coefficient de corrélation -->'+str(coeffcorel)) # Affichage du coefficient de correlation

#Calcul des coordonnées un points appartenant à la droite de régression
# ce point est utilisé pour tracer la droite sur le graphe
# la droite est tracé entre les points de coordonnées (0,0).et (a_3_max , T_2_max)
a_3_max = LIST_a[len(LIST_a)-1]
T_2_max =pente *a_3_max + ordorigine 

#Affichage du graphe
plt.grid(True)
plt.xlabel("a au cube (m3)" ) 
plt.ylabel("periode au carré (s2)")
 
plt.scatter(LIST_a,LIST_T,s = 100,c ='red',marker ='+') # affichage des points

# Affichage des noms et de la droite de regression
for i in range (0,len(LIST_a)): 
   plt.text(LIST_a[i],LIST_T[i], LIST_P[i],fontsize =8)
   plt.plot ([0,a_3_max],[ordorigine,T_2_max],c ='blue')
plt.show()