﻿# Lecture de l'image sous forme d'un tableau de nombres
import matplotlib.image as mpimg                # ou "import imageio as mpimg"
import numpy as np
photoOriginale = mpimg.imread("monImage.jpg")   # image placée dans le même dossier que le fichier python ou copier le chemin d'accès

# Affichage de l'image originale avec un titre
import matplotlib.pyplot as plt
plt.imshow(photoOriginale)
plt.title('Photo originale')
plt.show()

# Définition de la fonction filtre_rouge
def filtre_rouge( image ):
    photo = np.copy(image)                      # copie de l'image à filtrer
    for i in range(photo.shape[0]):             # i indique la ligne sur laquelle se trouve le pixel
        for j in range(photo.shape[1]):         # j indique la colonne sur laquelle se trouve le pixel
            r, v, b = photo[i, j]               # valeurs des composantes rouge, verte et bleue du pixel situé sur la ligne i et la colonne j
            photo[i, j] = (r, 0,0)              # conserve la valeur de la composante rouge et annule les composantes verte et bleue
    return photo

# Application de la fonction filtre_rouge à la photo choisie
photoFiltree = filtre_rouge(photoOriginale)

# Affichage de l'image obtenue
plt.imshow(photoFiltree)
plt.title('Photo avec un filtre rouge')
plt.show()


