# On importe la fonction 'sin' et la constante 'pi' de la bibliothèque 'math'

from math import sin, pi



# On a besoin de 'pyplot' (objet du module 'matplotlib')

# pour pouvoir tracer des courbes

# Pour créer une animation, on a besoin de 'matplotlib.animation'

import matplotlib.pyplot as plt # plt sera l'alias de 'pylot'

import matplotlib.animation as anim #animation sera l'alias de 'animation'



####  Paramètres ################################################################  

Xmax = 10.0           # échelle max selon l'axe de propagation                  #

Tmax = 10.0           # échelle max selon le temps                              #

NbEchantillons = 100  # nombre d'échantillons                                   #

T = 2.0               # période                                                 #

c = 1.0               # vitesse                                                 #

#################################################################################



# On définit un nom de variable pour la figure et pour les axes (x,y), 

# auxquels on rajoutera les courbes

fig = plt.figure()

ax = plt.axes(xlim = (0, Xmax), ylim = (-2, 2))



# On définit les positions de calcul de la courbe (abscisses communes) :

positionsx = [ i*Xmax/NbEchantillons for i in range(NbEchantillons) ]



# On définit les instants de calcul de la courbe :

temps = [ i*Tmax/NbEchantillons for i in range(NbEchantillons) ]





# mescourbes est une liste qui contient les listes des valeurs d'ordonnées :

mescourbes = [ [ sin(2*pi/T*(t-x/c)) for x in positionsx ] for t in temps ]



# On initialise courbe :

courbe, = ax.plot(positionsx,mescourbes[0]) # la virgule sert à unpacker courbe 



# On crée une fonction pour extraire les ordonnées de la courbe à chaque instant

def incrementemps(i):

	courbe.set_ydata(mescourbes[i])

	return courbe,



# On ajoute un titres pour chaque axe et pour le graphique

ax.set_xlabel('X')

ax.set_ylabel('Y')

ax.set_title('Une onde?')



# On crée l'animation et on l'affiche

line_ani = anim.FuncAnimation(fig, incrementemps, 100, interval=50)

plt.show()

