# On importe la bibliothèque qui permet de faire des tracés.
# On la renome plt pour gagner du temps par la suite
import matplotlib.pyplot as plt

####   Coordonnées des points du solide en fonction du temps    ##############
x=[2,3.38,5.12,7.22,9.68]       # saisie des x                               #
y=[0.8,1.352,2.048,2.888,3.872] # saisie des y                               #
t=[1,1.3,1.6,1.9,2.2]           # temps                                      #
##############################################################################


####   On calcule les coordonnées X et Y du vecteur vitesse     ##############
# avec les points d'avant et d'après (points encadrants)                     #
X=[] ;Y=[]                                                                   #
for i in range(0,len(x)-1):                                                  #
    X.append((x[i+1]-x[i])/(t[i+1]-t[i]))                                    #
    Y.append((y[i+1]-y[i])/(t[i+1]-t[i]))                                    #
  xv=x[0:len(x)-1] # Le premier point et le dernier n'ont pas de vitesse     #
yvyv=y[0:len(y)-1] # calculable avec la méthode des points encadrants        #
##############################################################################


####   On calcule les coordonnées VarX et VarY du vecteur variation de  ######
# vitesse avec les points d'avant et d'après (points encadrants)             #
VarX=[] ; VarY=[]                                                            #
for i in range(0, len(X)-1):                                                 #
    VarX.append(X[i+1]-X[i])                                                 #
    VarY.append(Y[i+1]-Y[i])                                                 #
xvar=x[1:len(x)-1]                                                           #
yvar=y[1:len(y)-1]                                                           #
##############################################################################


###### On trace le champs de vecteurs:   #####################################
# Le paramètre 'scale' permet d'agir sur l'unité pour la longueur des flèches#
                                                                             #
# Dans le premier graphique, les vecteurs vitesses, de coordonnées X et Y    #
plt.subplot(2,1,1)                                                           #
plt.quiver(xv,yv,X,Y,angles="xy",scale_units="xy",scale=5,color="green")     #
plt.plot(x,y,"ro")                                                           #
plt.title("Vecteurs vitesse")                                                #
plt.axis([0, 10, 0.5, 4])                                                    #                              #
# Dans le second, graphique les vecteurs variations de vitesse,              #
# de coordonnées VarX et VarY                                                #
plt.subplot(2,1,2)                                                           #
plt.quiver(xvar,yvar,VarX,VarY,angles="xy",scale_units="xy",scale=2,         #
           color="blue")                                                     #
plt.plot(x,y,"ro")                                                           #
plt.title("Vecteurs variations de vitesse")                                  #
plt.axis([0, 10, 0.5, 4])                                                    #
##############################################################################

# On affiche
plt.show()

