# on importe la biliothèque qui permet de faire des tracés
# on la renomme plt pour gagner du temps par la suite
import matplotlib.pyplot as plt

####   Coordonnées des points du solide en fonction du temps    ##############
x=[1,2,3.5,4.2,4.5]     # saisie des x                                       #
y=[1,1.3,1.5,1.4,1.3]   # saisie des y                                       #
t=[0,0.1,0.3,0.5,0.9]   # temps                                              #
##############################################################################

####   On calcule les coordonnées X et Y du vecteur vitesse     ##############
# avec les points d'avant et d'après (points encadrants)                     #
X=[] ; Y=[] ; T=[]                                                           #
for i in range(1,len(x)-1):                                                  #
    X.append((x[i+1]-x[i])/(t[i+1]-t[i]))                                    #
    Y.append((y[i+1]-y[i])/(t[i+1]-t[i]))                                    #
##############################################################################

#### Le premier point et le dernier n'ont pas de vitesse calculable
# avec la méthode des points encadrants
xv=x[1:len(x)-1]
yv=y[1:len(y)-1]

# On trace le champs de vecteur de coordonnées X et Y
# Le paramètre 'scale' permet d'agir sur l'unité pour la longueur des flèches
plt.quiver(xv,yv,X,Y,angles="xy",scale_units="xy",scale=10)
plt.plot(x,y,"ro")
plt.axis([0,5,0.5,2])

# On affiche 
plt.show()
